<?php
/** Vrácení českého názvu měsíce
 * @param int 1-12
 * @return string
 * @copyright Jakub Vrána, http://php.vrana.cz/
 */



function cesky_mesic($mesic) {
    static $nazvy = array(1 => 'leden', 'únor', 'březen', 'duben', 'květen', 'červen', 'červenec', 'srpen', 'září', 'říjen', 'listopad', 'prosinec');
    return mb_convert_case( $nazvy[$mesic], MB_CASE_TITLE, 'UTF-8');

}

function mesic_cislo($mesic){
    static $nazvy = array(1 => 'leden', 'únor', 'březen', 'duben', 'květen', 'červen', 'červenec', 'srpen', 'září', 'říjen', 'listopad', 'prosinec');
    $mes = mb_convert_case($mesic, MB_CASE_LOWER, 'UTF-8');

    $index = array_search($mes, $nazvy);
    return $index;
}



/** Vrácení českého názvu dne v týdnu
 * @param int 0-6, 0 neděle
 * @return string
 * @copyright Jakub Vrána, http://php.vrana.cz/
 */
function cesky_den($den) {
    static $nazvy = array('neděle', 'pondělí', 'úterý', 'středa', 'čtvrtek', 'pátek', 'sobota');
    return $nazvy[$den];
}

    //echo cesky_mesic(date("n")) . "\n";
    //echo cesky_den(date("w")) . "\n";
?>